!        Generated by TAPENADE     (INRIA, Ecuador team)
!  Tapenade 3.12 (r6213) - 13 Oct 2016 10:54
!
!  Differentiation of dpls in forward (tangent) mode:
!   variations   of useful results: cfh0 cftt cfqt cfut cfle deltatheta
!   with respect to varying inputs: cfal cf0 cf2 cf3 cfua cz0 cft2
!                chu pl
!stable
SUBROUTINE DPLS_DV(pl, pld, cz0, cz0d, chu, chud, cfua, cfuad, cf0, cf0d&
& , cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald, cfut, cfutd, cfqt, &
& cfqtd, cftt, cfttd, cfh0, cfh0d, cfle, cfled, deltatheta, deltathetad&
& , nbdirs)
  USE DIFFSIZES
!  Hint: nbdirsmax should be the maximum number of differentiation directions
  IMPLICIT NONE
!input
  REAL, INTENT(IN) :: pl, cz0, chu, cfua, cf0, cf2, cf3, cft2, cfal
  REAL, DIMENSION(nbdirsmax), INTENT(IN) :: pld, cz0d, chud, cfuad, cf0d&
& , cf2d, cf3d, cft2d, cfald
!output
  REAL, INTENT(OUT) :: cfut, cfqt, cftt, cfh0, cfle, deltatheta
  REAL, DIMENSION(nbdirsmax), INTENT(OUT) :: cfutd, cfqtd, cfttd, cfh0d&
& , cfled, deltathetad
!local
  REAL :: a, b, c, d, tr, t0, g
  REAL, DIMENSION(nbdirsmax) :: ad, bd, cd, dd, trd, t0d, gd
  INTRINSIC EXP
  REAL :: arg1
  REAL, DIMENSION(nbdirsmax) :: arg1d
  REAL :: arg2
  REAL, DIMENSION(nbdirsmax) :: arg2d
  INTEGER :: nd
  INTEGER :: nbdirs
  arg1 = -(.29*cz0*pl)
  arg2 = -(.29*chu*pl)
  a = 17.0*(EXP(arg1)-EXP(arg2))
  b = 240.0*pl
  c = 250.0*pl
  cfut = .4*cfua/(cf0+a)
  d = cfut*cfut*pl/1.5696
  tr = (cft2-0.48)/(1.0-d*(3.218875825+b))
  t0 = tr - tr*d*(12.+c) + 0.5
  cfqt = cf2 - .567*(t0**4-.935*tr**6/100000.0)/10000000.0
  g = -(5.0*(tr-t0))
  cftt = .4*d*tr
  DO nd=1,nbdirs
!Below Eq. 1 in Karppinen et al. 1997
!A=psi_m(z_0/L)-psi_m(z/L)
    arg1d(nd) = -(.29*(cz0d(nd)*pl+cz0*pld(nd)))
    arg2d(nd) = -(.29*(chud(nd)*pl+chu*pld(nd)))
    ad(nd) = 17.0*(arg1d(nd)*EXP(arg1)-arg2d(nd)*EXP(arg2))
!Equation 9b in van Ulden and Holtslag 1985
!B = -psi_h(z=48,L) = 5*z/L = 5*48/L = 240*1/L
    bd(nd) = 240.0*pld(nd)
!Equation 9b in van Ulden and Holtslag 1985
!C = -psi_h(z=50,L) = 5*z/L = 5*50/L = 250*1/L
    cd(nd) = 250.0*pld(nd)
!Equation 8 in van Ulden and Holtslag 1985 for u*
!u* = k*U(z)/(ln(z/z0)+psi_m(z_0/L)-psi_m(z/L))
    cfutd(nd) = (.4*cfuad(nd)*(cf0+a)-.4*cfua*(cf0d(nd)+ad(nd)))/(cf0+a)&
&     **2
!D = u*²/(L*g*k*k) = theta*/(k*TR), Note: PL = 1/L
    dd(nd) = ((cfutd(nd)*cfut+cfut*cfutd(nd))*pl+cfut**2*pld(nd))/1.5696
    trd(nd) = (cft2d(nd)*(1.0-d*(3.218875825+b))-(cft2-0.48)*(-(dd(nd)*(&
&     3.218875825+b))-d*bd(nd)))/(1.0-d*(3.218875825+b))**2
    t0d(nd) = trd(nd) - (trd(nd)*d+tr*dd(nd))*(12.+c) - tr*d*cd(nd)
!Eq. 21 from van Ulden and Holtslag 1985
!T0**4 and TR**6 for easier reading. This produces the same result as in the F77 version of EVUOT to the 4th decimal
    cfqtd(nd) = cf2d(nd) - .567*(4*t0**3*t0d(nd)-.935*6*tr**5*trd(nd)/&
&     100000.0)/10000000.0
!ground flux estimated from the temperature difference between TR and T0
    gd(nd) = -(5.0*(trd(nd)-t0d(nd)))
!solve theta* from van Ulden and Holtslag 1985 Eq. 6 -->
!theta* = TR*u*²/(k*g*L), CFTT = k * u*²/(L*g*k*k) * TR = TR*u*²/(L*g*k) = theta* (temperature scale)
    cfttd(nd) = .4*(dd(nd)*tr+d*trd(nd))
!rho(T2) = rho_ref*T_ref/T2
!349477.0 = T_ref ~ 288 K and rho ref ~ 1.2 kg/m³ and c_p ~ 1011 kJ/(kg*K)
!CFH0 = rho(T) * c_p * theta* * u*, Eq. 5 in van Ulden and Holtslag 1985
    cfh0d(nd) = -((349477.0*(cfttd(nd)*cfut+cftt*cfutd(nd))*cft2-&
&     349477.0*cftt*cfut*cft2d(nd))/cft2**2)
!lambdaE = Q_E = Q*-G-H_0, Eq. 10 in van Ulden and Holtslag 1985
    cfled(nd) = cfqtd(nd) - gd(nd) - cfh0d(nd)
!deltaTheta = theta* - (aS/(S+1)-1)(Q*-G)/(rho*c_p*u*)-theta_d*a: the right hand term is Eq. 6 in Karppinen 
!et al. 1997. CF3 = (aS/(S+1)-1)/(rho(T)*c_p)
!deltaTheta is the difference between the temperature scale calculated from the energy budget equations 
!and using the "profile method". The iteration is done by changing 1/L.
    deltathetad(nd) = cfttd(nd) - ((cf3d(nd)*(cfqt-g)+cf3*(cfqtd(nd)-gd(&
&     nd)))*cfut-cf3*(cfqt-g)*cfutd(nd))/cfut**2 - .033*cfald(nd)
  END DO
  cfh0 = -(349477.0*cftt*cfut/cft2)
  cfle = cfqt - g - cfh0
  deltatheta = cftt - cf3*(cfqt-g)/cfut - .033*cfal
END SUBROUTINE DPLS_DV
