!        Generated by TAPENADE     (INRIA, Ecuador team)
!  Tapenade 3.12 (r6213) - 13 Oct 2016 10:54
!
!  Differentiation of dpll in forward (tangent) mode:
!   variations   of useful results: cfh0 cftt cfqt cfut cfle deltatheta
!   with respect to varying inputs: cfal cf0 cf2 cf3 cfua cz0 cft2
!                chu pl
!unstable
SUBROUTINE DPLL_DV(pl, pld, cz0, cz0d, chu, chud, cfua, cfuad, cf0, cf0d&
& , cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald, cfut, cfutd, cfqt, &
& cfqtd, cftt, cfttd, cfh0, cfh0d, cfle, cfled, deltatheta, deltathetad&
& , nbdirs)
  USE DIFFSIZES
!  Hint: nbdirsmax should be the maximum number of differentiation directions
  IMPLICIT NONE
!input
  REAL, INTENT(IN) :: pl, cz0, chu, cfua, cf0, cf2, cf3, cft2, cfal
  REAL, DIMENSION(nbdirsmax), INTENT(IN) :: pld, cz0d, chud, cfuad, cf0d&
& , cf2d, cf3d, cft2d, cfald
!output
  REAL, INTENT(OUT) :: cfut, cfqt, cftt, cfh0, cfle, deltatheta
  REAL, DIMENSION(nbdirsmax), INTENT(OUT) :: cfutd, cfqtd, cfttd, cfh0d&
& , cfled, deltathetad
!local
  REAL :: a, b, c, cc, d, tr, t0, g
  REAL, DIMENSION(nbdirsmax) :: ad, bd, cd, ccd, dd, trd, t0d, gd
  INTRINSIC SQRT
  INTRINSIC ALOG
  REAL :: arg1
  REAL, DIMENSION(nbdirsmax) :: arg1d
  REAL :: result1
  REAL, DIMENSION(nbdirsmax) :: result1d
  REAL :: arg2
  REAL, DIMENSION(nbdirsmax) :: arg2d
  INTEGER :: nd
  INTEGER :: nbdirs
  a = (1.0-16.0*cz0*pl)**.25 - (1.0-16.0*chu*pl)**.25
  arg1 = 1.0 - 800.0*pl
  cfut = .4*cfua/(cf0+a)
  DO nd=1,nbdirs
!Eq. 2 in Karppinen et al. 1997: A=-psi_m(z/L)+psi_m(z_0/L)
!PL = 1/L, CZ0 roughness length, CHU = wind speed mesasurement height
    ad(nd) = .25*(1.0-16.0*chu*pl)**(-0.75)*16.0*(chud(nd)*pl+chu*pld(nd&
&     )) - .25*(1.0-16.0*cz0*pl)**(-0.75)*16.0*(cz0d(nd)*pl+cz0*pld(nd))
!psi_H = 2*alog([1+y²]/2)
!C = 1+y² where y=(1-16*z/L)^(1/4) from van Ulden and Holtslag 1985 Eqs 9 and 9a: z3=50 meters and PL = 1/L
    arg1d(nd) = -(800.0*pld(nd))
    IF (arg1 .EQ. 0.0) THEN
      result1d(nd) = 0.0
    ELSE
      result1d(nd) = arg1d(nd)/(2.0*SQRT(arg1))
    END IF
    cd(nd) = result1d(nd)
!B = -psi_H(z3/L)+psi_H(z2/L) where psi_H = 2*log([1+y²]/2) and y=(1-16*z/L)^(1/4), z3=50 meters, z2 = 2 meters
    arg1d(nd) = -(32.0*pld(nd))
!CFUT = friction velocity from Eq. 1 in Karppinen et al. 1997
!u* = U(z)*k/(ln(z/z_0)-psi_m(z/L)+psi_m(z_0/L)) where CF0=ln(z/z_0)
    cfutd(nd) = (.4*cfuad(nd)*(cf0+a)-.4*cfua*(cf0d(nd)+ad(nd)))/(cf0+a)&
&     **2
!D = u*²/(L*g*k*k) = theta*/k, Note: PL = 1/L
    dd(nd) = ((cfutd(nd)*cfut+cfut*cfutd(nd))*pl+cfut**2*pld(nd))/1.5696
  END DO
  result1 = SQRT(arg1)
  c = 1.0 + result1
  arg1 = 1.0 - 32.0*pl
  result1 = SQRT(arg1)
  arg2 = (1.0+result1)/c
  b = 2.0*ALOG(arg2)
  d = cfut*cfut*pl/1.5696
  tr = (cft2-0.48)/(1.0-d*(3.218875825+b))
  cftt = .4*d*tr
  DO nd=1,nbdirs
    IF (arg1 .EQ. 0.0) THEN
      result1d(nd) = 0.0
    ELSE
      result1d(nd) = arg1d(nd)/(2.0*SQRT(arg1))
    END IF
    arg2d(nd) = (result1d(nd)*c-(1.0+result1)*cd(nd))/c**2
    bd(nd) = 2.0*arg2d(nd)/arg2
!CC = -2*log([1+y²]/2) = 2*log(2/[1+sqrt(1-16*50/L)])
    arg1d(nd) = -(2.0*cd(nd)/c**2)
    trd(nd) = (cft2d(nd)*(1.0-d*(3.218875825+b))-(cft2-0.48)*(-(dd(nd)*(&
&     3.218875825+b))-d*bd(nd)))/(1.0-d*(3.218875825+b))**2
!solve theta* from van Ulden and Holtslag 1985 Eq. 6 -->
!theta* = T*u*²/(k*g*L), CFTT = k * u*²/(L*g*k*k) * T = T*u*²/(L*g*k) = theta* (temperature scale)
    cfttd(nd) = .4*(dd(nd)*tr+d*trd(nd))
!rho(T2) = rho_ref*T_ref/T2
!349477.0 = T_ref ~ 288 K and rho ref ~ 1.2 kg/m³ and c_p ~ 1011 kJ/(kg*K)
!CFH0 = rho(T) * c_p * theta* * u*, Eq. 5 in van Ulden and Holtslag 1985
    cfh0d(nd) = -((349477.0*(cfttd(nd)*cfut+cftt*cfutd(nd))*cft2-&
&     349477.0*cftt*cfut*cft2d(nd))/cft2**2)
  END DO
  arg1 = 2.0/c
  cc = 2.0*ALOG(arg1)
  t0 = tr - tr*d*(12.+cc) + 0.5
  cfqt = cf2 - .567*(t0**4-.935*tr**6/100000.0)/10000000.0
  g = -(5.0*(tr-t0))
  DO nd=1,nbdirs
    ccd(nd) = 2.0*arg1d(nd)/arg1
    t0d(nd) = trd(nd) - (trd(nd)*d+tr*dd(nd))*(12.+cc) - tr*d*ccd(nd)
!Eq. 21 from van Ulden and Holtslag 1985
!T0**4 and TR**6 for easier reading. This produces the same result as in the F77 version of EVUOT to the 4th decimal
    cfqtd(nd) = cf2d(nd) - .567*(4*t0**3*t0d(nd)-.935*6*tr**5*trd(nd)/&
&     100000.0)/10000000.0
!ground flux estimated from the temperature difference between TR and T0
    gd(nd) = -(5.0*(trd(nd)-t0d(nd)))
!lambdaE = Q_E = Q*-G-H_0, Eq. 10 in van Ulden and Holtslag 1985
    cfled(nd) = cfqtd(nd) - gd(nd) - cfh0d(nd)
!DPLL = theta* - (aS/(S+1)-1)(Q*-G)/(rho*c_p*u*)-theta_d*a: the right hand term is Eq. 6 in Karppinen et al. 1997
!CF3 = (aS/(S+1)-1)/(rho(T)*c_p)
!deltaTheta is the difference between the temperature scale calculated from the energy budget equations and 
!using the "profile method". The iteration is done by changing 1/L.
    deltathetad(nd) = cfttd(nd) - ((cf3d(nd)*(cfqt-g)+cf3*(cfqtd(nd)-gd(&
&     nd)))*cfut-cf3*(cfqt-g)*cfutd(nd))/cfut**2 - .033*cfald(nd)
  END DO
  cfh0 = -(349477.0*cftt*cfut/cft2)
  cfle = cfqt - g - cfh0
  deltatheta = cftt - cf3*(cfqt-g)/cfut - .033*cfal
END SUBROUTINE DPLL_DV
