!        Generated by TAPENADE     (INRIA, Ecuador team)
!  Tapenade 3.12 (r6213) - 13 Oct 2016 10:54
!
!  Differentiation of do_evuot in forward (tangent) mode:
!   variations   of useful results: results
!   with respect to varying inputs: cfab cfnh cfal cfas cfua cfhh
!                cz0 cft2 chu cla clo
!   RW status of diff variables: cfab:in results:out cfnh:in cfal:in
!                cfas:in cfua:in cfhh:in cz0:in cft2:in chu:in
!                cla:in clo:in
!the acutal subroutine that does the work ----------------------------->
SUBROUTINE DO_EVUOT_DV(cfnr, cfst, cfvu, cfku, cfpv, cfkl, cfpr, cft2, &
& cft2d, cfuu, cfsu, cfnn, cftd, cftw, cfrr, cfvv, cfww, cfw1, cfw2, &
& cfnh, cfnhd, cfcl, cfhh, cfhhd, cfcm, cfch, cfdd, cfua, cfuad, cfap, &
& cfab, cfabd, cfas, cfasd, cfal, cfald, alb, cla, clad, clo, clod, cz0&
& , cz0d, chu, chud, results, resultsd, nbdirs)
  USE DIFFSIZES
!  Hint: nbdirsmax should be the maximum number of differentiation directions
  IMPLICIT NONE
!input data
  REAL, INTENT(IN) :: cfnr, cfst, cfvu, cfku, cfpv, cfkl, cfpr, cft2, &
& cfuu, cfsu, cfnn, cftd, cftw, cfrr, cfvv, cfww, cfw1, cfw2, cfnh, cfcl&
& , cfhh, cfcm, cfch, cfdd, cfua, cfap, cfab, cfas, cfal, cla, clo, cz0&
& , chu
  REAL, DIMENSION(nbdirsmax), INTENT(IN) :: cft2d, cfnhd, cfhhd, cfuad, &
& cfabd, cfasd, cfald, clad, clod, cz0d, chud
  REAL, DIMENSION(10), INTENT(IN) :: alb
!output data
  REAL, DIMENSION(10), INTENT(OUT) :: results
  REAL, DIMENSION(nbdirsmax, 10), INTENT(OUT) :: resultsd
!local variables 
  REAL :: cfak, cfpl, cftt, cfut, cfh0, cfqt, cfle, cfh1, cfh2, cfwt, &
& cfgr, cf0, cf1, cf2, cf3, cf4, CLRAD, un
  REAL, DIMENSION(nbdirsmax) :: cfakd, cfpld, cfttd, cfutd, cfh0d, cfqtd&
& , cfled, cf0d, cf2d, cf3d, cf4d, und
  REAL :: sg, c1, pp, si, sn, cs, s, tr, t0, a, rv, d, pl, deltatheta, &
& deltatheta_dx, x, dx, e, tc, b0, gr, x1, x2
  REAL, DIMENSION(nbdirsmax) :: sd, trd, t0d, ad, rvd, dd, pld, &
& deltathetad, deltatheta_dxd, xd, tcd, b0d, grd, x1d, x2d
  INTEGER :: iv, ik, ip, il, i, n
  INTRINSIC INT
  INTRINSIC EXP
  INTRINSIC ALOG
  INTRINSIC ABS
  REAL :: abs0
  REAL :: abs1
  REAL :: result1
  REAL, DIMENSION(nbdirsmax) :: result1d
  REAL :: arg1
  REAL, DIMENSION(nbdirsmax) :: arg1d
  REAL :: arg10
  REAL, DIMENSION(nbdirsmax) :: arg10d
  INTEGER :: nd
  INTEGER :: nbdirs
!match the surface albedo with the ground surface quality/state (CFSU 0-9) to the ten albedo values in the control file 
!CFAB=ALB(INT(CFSU)+1)
!Stefan Boltsman's constant 5.67e-8 W/(m^2 K)
  sg = .567/10000000.0
!Emprirical constant from van Ulden and Holtslag 1985 (Journal of Climate an Applied Meteorology) 9.35e-6 K⁻²
  c1 = .935/100000.0
  iv = INT(cfvu)
  ik = INT(cfku)
  ip = INT(cfpv)
  il = INT(cfkl)
!SALFA returns the sun elevation angle in degrees and calculates various help variables such as azimuth and zenith angles
!Input: IV=year (yy), IK=Month (mm), IP=Day (dd), IL=clock (HHMM), CLA=lat, CLO=lon, 
!Output("dummy arguments"): PP=solar midday difference in hours, SI=sin of the elevation angle, SI= sin of the azimut angle,
!CS=cos of the azimut angle
!CFAK=solar elevation in degrees
!CALL to get the value for CFAK
  CALL SALFA_DV(iv, ik, ip, il, cla, clad, clo, clod, pp, si, sn, cs, &
&         cfak, cfakd, nbdirs)
!The subroutine returns the ground moisture parameters according to precipitation codes for the present 
!(CFWW), past 3 hours (CFW2) and past hour (CFW1). 
!If the CFW1 and CFW2 values are missing --> moisture parameter seems to become 1.
!CALL to get the value for CFAL
!COMMENTED TO TEST SENSITIVITY OF MOISTURE PARAMETER AS INPUT PARAMETER
!CALL ALFM(CFAK,CFSU,CFWW,CFW1,CFW2,CFRR,CFAL)
!SI=sinus of the solar elevation angle produced by the subroutine SALFA()
!CFAP = hourly amount of sunshine
!get the value for CFAS --> presenty prohibited by declaring CFAS as INTENT(IN)
!if you want to use CFAS declare CFAS as INTENT(INOUT) for the subroutine
!CALL GLOB(SI,CFAP,CFAS)
!The term CFAS*(1.0-CFAB) = K* (Net shortwave radiation) = (1-albedo)*R_S(K_R) (Eq. 10 in Karppinen et al. 1997)
!CF2 = K* + L_c
  CALL CLRAD_DV(cft2, cft2d, cfnh, cfnhd, cfhh, cfhhd, cfsu, result1, &
&         result1d, nbdirs)
  arg1 = 5423.0*(1.0/273.16-1.0/cft2)
  s = 51371.0*EXP(arg1)/(cft2*cft2)
  cf3 = cft2*(cfal*s/(s+1.0)-1.0)/349477.0
  arg10 = chu/cz0
  cf0 = ALOG(arg10)
  un = .4*cfua/cf0
  tr = cft2 - .48
  t0 = cft2 + 0.02
  DO nd=1,nbdirs
    cf2d(nd) = cfasd(nd)*(1.0-cfab) - cfas*cfabd(nd) + result1d(nd)
!S is the slope of the saturation entalphy curve (sat vap pres curve). CFT2 is the temperature at 2 metres.  
!Karppinen et al. 1997 (Int. J. Env and Poll.) between Eq. 5 and Table 1
!The equation is not exactly the same though: T2^2 here and T2 in Karppinen et al. 1997 
!Equation calculated as suggested by Dop et al. 1982:
    arg1d(nd) = 5423.0*cft2d(nd)/cft2**2
    sd(nd) = (51371.0*arg1d(nd)*EXP(arg1)*cft2**2-51371.0*EXP(arg1)*(&
&     cft2d(nd)*cft2+cft2*cft2d(nd)))/(cft2*cft2)**2
!Eq. 6 in Karppinen et al. 1997 (Int. J. Env and Poll.) but the density of air is scaled to the temperature CFT2
!349477.0 = c_p*rho_ref*288 K
!The density of air at the temperature T2 is rho(T2) = rho_ref*T_ref/T2 --> into Equation below 
!--> (aS/(S+1)-1)/c_p * (T2/T_ref*rho_ref) where T_ref ~ 288 K and rho_ref ~ 1.2 kg/m³ and c_p ~ 1011 kJ/(kg*K)
!Then CF3 = (aS/(S+1)-1)/(rho(T)*c_p)
    cf3d(nd) = (cft2d(nd)*(cfal*s/(s+1.0)-1.0)+cft2*((cfald(nd)*s+cfal*&
&     sd(nd))*(s+1.0)-cfal*s*sd(nd))/(s+1.0)**2)/349477.0
!ln(z/z_0) 
!CHU = wind speed measurement height, CZ0 = roughness parameter
    arg10d(nd) = (chud(nd)*cz0-chu*cz0d(nd))/cz0**2
    cf0d(nd) = arg10d(nd)/arg10
!u* friction velocity (UN) calculated without stability functions, Eq. 1 Karppinen et al. 1997
!CFUA = wind speed at 10 metres
    und(nd) = (.4*cfuad(nd)*cf0-.4*cfua*cf0d(nd))/cf0**2
!Subtract the temperature change from 2 meters to 50 meters --> 0.01K/m * (50m-2m) = 0.48K
    trd(nd) = cft2d(nd)
!This is the temperature at 0 meters using the lapse rate of 0.01K/m --> +0.02C for a drop in height by 2 meters
    t0d(nd) = cft2d(nd)
!Eq. 21 in van Ulden and Holtslag 1985 (Journal of Climate an Applied Meteorology)
!A = L_out - L_in = SG*T_0⁴ - SG*c_1*T_r⁶ (positive is upwards)
!SG*T_0⁴ is the outgoing longwave radiation. SG*c_1*T_r⁶ is the incomming longwave radiation from the atmosphere.
!A=-L_net  + first aprrox for G (~2.5 Wm⁻²) !could at least be changed to a diurnal variation of some sort
!T0**4 and TR**6 for easier reading. This produces the same result as in the F77 version of EVUOT to the 4th decimal
    ad(nd) = sg*(4*t0**3*t0d(nd)-c1*6*tr**5*trd(nd))
!CF4=-Lnet+G-thetad*alfa*UN*rho*cp/(alfa(s/(s+1))-1)
    cf4d(nd) = ad(nd) - (0.033*(cfald(nd)*un+cfal*und(nd))*cf3-0.033*&
&     cfal*un*cf3d(nd))/cf3**2
!3.924 = 9.81*0.4 = g*k
!RV = g*k*CF3/(T_R*u*³) when CF3 = (aS/(S+1)-1)/(rho(T)*c_p) then RV = g*k*(aS/(S+1)-1)/(Tr*u*³*rho*c_p)
    rvd(nd) = (3.924*cf3d(nd)*tr*un**3-3.924*cf3*((trd(nd)*un+tr*und(nd)&
&     )*un**2+tr*un*(und(nd)*un+un*und(nd))))/(tr*un*un*un)**2
  END DO
  cf2 = cfas*(1.0-cfab) + result1
  a = sg*(t0**4-c1*tr**6) + 2.5
  cf4 = a - 0.033*cfal*un/cf3
  rv = 3.924*cf3/(tr*un*un*un)
!NOTE: more important : (CF2-CF4)*alfa(s/(s+1)-1) ~ -lambdaE0 +(Q*-G) ~ H0 -> stability can be estimated from the sign 
!CF2-CF4: CF2 = K*+L_c, CF4 = L_out - L_in + G - thetad*a*u**rho*c_p/(a*S/(S+1)-1)
!CF2-CF4 = K*+L_c - L_out + L_in - G + thetad*a*u**rho*c_p/(a*S/(S+1)-1)
!K* + L_c + L_in-L_out = Q*
!CF2-CF4 = Q* - G  + thetad*a*u**rho*c_p/(a*S/(S+1)-1) = -H_0/(a*S/(S+1)-1)
!alternatively a more clear form would be: (CF2 - CF4)*(a*S(S+1)-1) = (a*S(S+1)-1)*(Q*-G)+thetad*a*u**rho*c_p 
!---> = (a*S(S+1)-1)(Q*-G)-(Q*-G)+thetad*a*u**rho*c_p = (a*S(S+1)-1)(Q*-G)+thetad*a*u**rho*c_p-(Q*-G) = lambdaE-(Q*-G) = -H_0
!Note that aS/(S+1) < 1 and therefore aS/(S+1)-1 < 0. The sign does not change with aS/(S+1)-1
!stable
  IF (cf2 - cf4 .LT. 0) THEN
    DO nd=1,nbdirs
!D = 1/L --> CF2-CF4 = -H_0/(aS/(S+1)-1), RV = g*k*(aS/(S+1)-1)/(T*u*³*rho*c_p). When L=T*u*²/(k*g*theta*) and 
!theta* = -H_0/(rho*c_p*u*) --> 1/L = -k*g*H_0/(T*u*³*rho*c_p) = RV*(CF2-CF4)
!D = 1/L inverse M-O length
      dd(nd) = rvd(nd)*(cf2-cf4) + rv*(cf2d(nd)-cf4d(nd))
    END DO
    d = rv*(cf2-cf4)
    DO nd=1,nbdirs
      cfh0d(nd) = 0.0
      cfttd(nd) = 0.0
      cfqtd(nd) = 0.0
      cfutd(nd) = 0.0
      pld(nd) = 0.0
      cfled(nd) = 0.0
    END DO
    DO i=1,10
      DO nd=1,nbdirs
!increase the inverse M-O length untill delta_theta* = T*u*²/(k*g*L) - (aS/(S+1)-1)(Q*-G)/(rho*c_p*u*)-theta_d*a
!changes sign i.e. becomes positive
        pld(nd) = i*dd(nd)
      END DO
      pl = d*i
      CALL DPLS_DV(pl, pld, cz0, cz0d, chu, chud, cfua, cfuad, cf0, cf0d&
&            , cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald, cfut, &
&            cfutd, cfqt, cfqtd, cftt, cfttd, cfh0, cfh0d, cfle, cfled, &
&            deltatheta, deltathetad, nbdirs)
      IF (deltatheta .GT. 0) EXIT
    END DO
    DO nd=1,nbdirs
!increments and tolerance for the loop
      xd(nd) = pld(nd)
    END DO
    x = pl
    dx = 0.00001
    e = 0.000001
!iterative loop
    DO n=1,20
!iterative loop --> change 1/L untill the temperature scale difference as returned in DPLS is less than E 
!with no more than 20 iterations. The variables CFUT, CFQT, CFTT, CFH0, and CFLE get their values here.
!check the subroutine to see which wariables are inputs and outputs
      CALL DPLS_DV(x, xd, cz0, cz0d, chu, chud, cfua, cfuad, cf0, cf0d, &
&            cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald, cfut, cfutd&
&            , cfqt, cfqtd, cftt, cfttd, cfh0, cfh0d, cfle, cfled, &
&            deltatheta, deltathetad, nbdirs)
      IF (deltatheta .GE. 0.) THEN
        abs0 = deltatheta
      ELSE
        abs0 = -deltatheta
      END IF
      IF (n .GT. 20 .OR. abs0 .LT. e) THEN
        EXIT
      ELSE
        DO nd=1,nbdirs
          arg10d(nd) = xd(nd)
        END DO
        arg10 = x + dx
        CALL DPLS_DV(arg10, arg10d, cz0, cz0d, chu, chud, cfua, cfuad, &
&              cf0, cf0d, cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald&
&              , cfut, cfutd, cfqt, cfqtd, cftt, cfttd, cfh0, cfh0d, &
&              cfle, cfled, deltatheta_dx, deltatheta_dxd, nbdirs)
        DO nd=1,nbdirs
!change 1/L, here X, in the right direction X2 = X1-DX*deltaTheta/(deltaTheta_dx-deltaTheta). 
!If the difference deltaTheta increases, decrease X, otherwise increase X. 
!Note that both deltaTheta = DPLS(X) and deltaTheta_dx = DPLS(X+DX) decreases with each iteration.
          xd(nd) = xd(nd) - (dx*deltathetad(nd)*(deltatheta_dx-&
&           deltatheta)-dx*deltatheta*(deltatheta_dxd(nd)-deltathetad(nd&
&           )))/(deltatheta_dx-deltatheta)**2
        END DO
        x = x - dx*deltatheta/(deltatheta_dx-deltatheta)
      END IF
    END DO
    DO nd=1,nbdirs
!Finaly set the value for the inverse M-O length...
      cfpld(nd) = xd(nd)
    END DO
    cfpl = x
!Unstable
  ELSE IF (cf2 - cf4 .GT. 0) THEN
    tc = cft2 - 273.16
    b0 = .0429*cfal - 2.1235 - (.012685+.046081/(cfal-4.2765))*tc + (&
&     .19806+.00962*cfal-(.00093463+.0013998/(cfal-2.1069))*tc)*cf0
    gr = .49957 + .0002*tc - (.001465+.000237*tc)*cfal + (.0029854-&
&     .0007136*cfal+(.000065522+.000077531/(cfal-1.828))*tc)/cz0
    x = rv*(cf2-cf4)
    x1 = 1000.0*rv
    x2 = x/x1
    arg10 = b0 + gr*ALOG(-x1)
    DO nd=1,nbdirs
!temperature in celcius	
      tcd(nd) = cft2d(nd)
!Empirical regression equations (B0 and GR, reference?) to find where to start the iteration to find 1/L
!CFAL = moisture parameter, CF0 = ln(z/z_0), TC = temperature in Celsius
!Does B0 refere to boyant production of TKE?
      b0d(nd) = .0429*cfald(nd) - (.012685+.046081/(cfal-4.2765))*tcd(nd&
&       ) + .046081*cfald(nd)*tc/(cfal-4.2765)**2 + (.00962*cfald(nd)-(&
&       .00093463+.0013998/(cfal-2.1069))*tcd(nd)+.0013998*cfald(nd)*tc/&
&       (cfal-2.1069)**2)*cf0 + (.19806+.00962*cfal-(.00093463+.0013998/&
&       (cfal-2.1069))*tc)*cf0d(nd)
!Does GR refere to flux into the ground?
      grd(nd) = .0002*tcd(nd) - .000237*tcd(nd)*cfal - (.001465+.000237*&
&       tc)*cfald(nd) + (((.000065522+.000077531/(cfal-1.828))*tcd(nd)-&
&       .0007136*cfald(nd)-.000077531*cfald(nd)*tc/(cfal-1.828)**2)*cz0-&
&       (.0029854-.0007136*cfal+(.000065522+.000077531/(cfal-1.828))*tc)&
&       *cz0d(nd))/cz0**2
!X = 1/L --> CF2-CF4 = -H_0/(aS/(S+1)-1), RV = g*k*(aS/(S+1)-1)/(T*u*³*rho*c_p). When L=T*u*²/(k*g*theta*) and 
!theta* = -H_0/(rho*c_p*u*) --> 1/L = -k*g*H_0/(T*u*³*rho*c_p) = RV*(CF2-CF4)
!X = 1/L inverse M-O length
      xd(nd) = rvd(nd)*(cf2-cf4) + rv*(cf2d(nd)-cf4d(nd))
!RV is always negative because of CF3 in RV since (aS/(S+1)-1) < 0 and therefore X1 is always negative ---> 
!needs to be so because it is in a logarithm in the following equation
      x1d(nd) = 1000.0*rvd(nd)
      x2d(nd) = (xd(nd)*x1-x*x1d(nd))/x1**2
!empirical formula to find the best guess for 1/L based on moisture parameter (CFAL), temperature (TC), 
!roughness length (CZ0) and CF0
      arg10d(nd) = b0d(nd) + grd(nd)*ALOG(-x1) + gr*x1d(nd)/x1
      xd(nd) = (xd(nd)*(1.0-x/(EXP(arg10)*x2*(.45042*x2+.81505)/(x2+&
&       .26547)))+x*(xd(nd)*EXP(arg10)*x2*(.45042*x2+.81505)/(x2+.26547)&
&       -x*((arg10d(nd)*EXP(arg10)*x2*(.45042*x2+.81505)+EXP(arg10)*(x2d&
&       (nd)*(.45042*x2+.81505)+x2*.45042*x2d(nd)))*(x2+.26547)-EXP(&
&       arg10)*x2*(.45042*x2+.81505)*x2d(nd))/(x2+.26547)**2)*(x2+.26547&
&       )**2/(EXP(arg10)**2*x2**2*(.45042*x2+.81505)**2))/(1.0-x/(EXP(&
&       arg10)*x2*(.45042*x2+.81505)/(x2+.26547)))**2
    END DO
    x = x/(1.0-x/(EXP(arg10)*x2*(.45042*x2+.81505)/(x2+.26547)))
!initiation of the loop
    dx = -0.00001
    e = 0.000001
    DO nd=1,nbdirs
      cfh0d(nd) = 0.0
      cfttd(nd) = 0.0
      cfqtd(nd) = 0.0
      cfutd(nd) = 0.0
      cfled(nd) = 0.0
    END DO
!iterative loop
    DO n=1,20
!check the subroutine DPLL to see which variables are inputs and outputs
!DPLL returns the difference between theta* from the profile method and theta* from the energy balance equations.
      CALL DPLL_DV(x, xd, cz0, cz0d, chu, chud, cfua, cfuad, cf0, cf0d, &
&            cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald, cfut, cfutd&
&            , cfqt, cfqtd, cftt, cfttd, cfh0, cfh0d, cfle, cfled, &
&            deltatheta, deltathetad, nbdirs)
      IF (deltatheta .GE. 0.) THEN
        abs1 = deltatheta
      ELSE
        abs1 = -deltatheta
      END IF
      IF (n .GT. 20 .OR. abs1 .LT. e) THEN
        EXIT
      ELSE
        DO nd=1,nbdirs
!change 1/L, here X, until the temperature scale difference as returned in DPLL is less than E with no more than
!20 iterations. Note that DX is negative here.
          arg10d(nd) = xd(nd)
        END DO
        arg10 = x + dx
        CALL DPLL_DV(arg10, arg10d, cz0, cz0d, chu, chud, cfua, cfuad, &
&              cf0, cf0d, cf2, cf2d, cf3, cf3d, cft2, cft2d, cfal, cfald&
&              , cfut, cfutd, cfqt, cfqtd, cftt, cfttd, cfh0, cfh0d, &
&              cfle, cfled, deltatheta_dx, deltatheta_dxd, nbdirs)
        DO nd=1,nbdirs
          xd(nd) = xd(nd) - (dx*deltathetad(nd)*(deltatheta_dx-&
&           deltatheta)-dx*deltatheta*(deltatheta_dxd(nd)-deltathetad(nd&
&           )))/(deltatheta_dx-deltatheta)**2
        END DO
        x = x - dx*deltatheta/(deltatheta_dx-deltatheta)
      END IF
    END DO
    DO nd=1,nbdirs
      cfpld(nd) = xd(nd)
    END DO
    cfpl = x
!None of the above holds true
  ELSE
!Set the value for the inverse M-O length = 0
    cfpl = 0.0
!sensible heat flux H0 = 0	
    cfh0 = 0
    DO nd=1,nbdirs
!CF2 = K* + L_c and -A = L_net - G --> CFLE = K* + L_c + L_net - G  = Q* - G ----> 
!H0 + lambdaE = Q* - G ---> when H0=0 then lambdaE = Q* - G
      cfled(nd) = cf2d(nd) - ad(nd)
!Q* = lambdaE-G + 0.05*z_0
      cfqtd(nd) = cfled(nd) + 0.05*cz0d(nd)
    END DO
    cfle = cf2 - a
    cfqt = cfle - 2.5 + 0.05*cz0
!+ other variables?! CFTT, CFUT
    DO nd=1,nbdirs
      cfh0d(nd) = 0.0
      cfpld(nd) = 0.0
      cfttd(nd) = 0.0
      cfutd(nd) = 0.0
    END DO
  END IF
  DO nd=1,nbdirs
!return the variables
    resultsd(nd, 1:10) = (/cfabd(nd), cfakd(nd), cfasd(nd), cfald(nd), &
&     cfpld(nd), cfttd(nd), cfutd(nd), cfh0d(nd), cfqtd(nd), cfled(nd)/)
  END DO
  results(1:10) = (/cfab, cfak, cfas, cfal, cfpl, cftt, cfut, cfh0, cfqt&
&   , cfle/)
END SUBROUTINE DO_EVUOT_DV
