!        Generated by TAPENADE     (INRIA, Ecuador team)
!  Tapenade 3.12 (r6213) - 13 Oct 2016 10:54
!
!  Differentiation of clrad in forward (tangent) mode:
!   variations   of useful results: clrad
!   with respect to varying inputs: h t c
!FUNCTION(S)
!CLRAD(CFT2,CFNH,CFHH,CFSU)
SUBROUTINE CLRAD_DV(t, td, c, cd, h, hd, su, clrad, clradd, nbdirs)
  USE DIFFSIZES
!  Hint: nbdirsmax should be the maximum number of differentiation directions
  IMPLICIT NONE
!input
  REAL, INTENT(IN) :: t, c, h, su
  REAL, DIMENSION(nbdirsmax), INTENT(IN) :: td, cd, hd
!local
  REAL, PARAMETER :: sg=.0000000567, c1=.00000935
  REAL :: f
  REAL, DIMENSION(nbdirsmax) :: fd
  INTEGER :: nd
  REAL :: clradd(nbdirsmax)
  REAL :: clrad
  INTEGER :: nbdirs
!No clouds, no radiation from them
  IF (c .LE. 0.0) THEN
    clrad = 0.0
    DO nd=1,nbdirs
      clradd(nd) = 0.0
    END DO
  ELSE
    DO nd=1,nbdirs
!Cloud base temperature T_c = T-0.01*H where T is the temperature at 2 meters and H is the cloud base height
!Eq. 14 in Karppinen et al. 1997 (Int. J. Env and Poll.)
!F here is L'_c in Eq. 14
      fd(nd) = sg*((cd(nd)*(1.0-c1*t*t)-c*c1*(td(nd)*t+t*td(nd)))*(t-.01&
&       *h)**4+c*(1.0-c1*t*t)*4*(t-.01*h)**3*(td(nd)-.01*hd(nd)))
    END DO
    f = c*sg*(1.0-c1*t*t)*(t-.01*h)**4
    IF (su .LT. 5.0) THEN
      DO nd=1,nbdirs
!For no snowcover on the ground Eq. 15a in Karppinen et al. 1997 (Int. J. Env and Poll.)
        clradd(nd) = .64*fd(nd)
      END DO
      clrad = .64*f
    ELSE
      DO nd=1,nbdirs
!For snow covered ground Eq. 15b in Karppinen et al. 1997 (Int. J. Env and Poll.)
        clradd(nd) = .56*fd(nd)
      END DO
      clrad = .56*f
    END IF
  END IF
END SUBROUTINE CLRAD_DV
