#!/bin/bash
module load compiler/intel/17.0.0 
#1 clean up previous output directories 
rm -rf cirrus
rm -rf stratus
#2. re-compile codes from scratch
if [ -d fjx_rrtmg_obj ]; then rm -Rf fjx_rrtmg_obj; fi
mkdir fjx_rrtmg_obj
# compile codes
/usr/bin/make
# 3. start cirrus by cp .bk over----------------------
cp Data/CTM_GrdCld_cirrus.bk Data/CTM_GrdCld.dat
# case 1 clear sky/SZA=0
R1="11.0  12.0 GMT, PHOTAU"
N1="11.0   0.0 GMT, SZA   "
sed -i "s/$R1/$N1/" Data/CTM_GrdCld.dat
./solarj > output
mv output output_clearsky_sza0
# case 1 cirrus/avg cld/SZA=0
R2="1    1   Cloud Flags"
N2="2    2   Cloud Flags"
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat 
./solarj > output
mv output output_cirrus_sza0
mv fj.dat fj_sza0.dat
mv sj_1.dat sj_1_sza0.dat
mv sj_2.dat sj_2_sza0.dat
mv SWbgt.dat SWbgt_sza0.dat
# case 1 clear sky  /SZA=21
R1="11.0   0.0 GMT, SZA   "
N1="11.0  21.2 GMT, SZA   "
R2="2    2   Cloud Flags"
N2="1    1   Cloud Flags"
sed -i "s/$R1/$N1/" Data/CTM_GrdCld.dat
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat 
./solarj > output
mv output output_clrsky_sza21
# case 1 cirrus/avg cld/SZA=21
R2="1    1   Cloud Flags"
N2="2    2   Cloud Flags"
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat
./solarj > output
mv output output_cirrus_sza21
mv fj.dat fj_sza21.dat
mv sj_1.dat sj_1_sza21.dat
mv sj_2.dat sj_2_sza21.dat
mv SWbgt.dat SWbgt_sza21.dat
# case 1 cirrus/avg cld/SZA=62
R1="11.0  21.2 GMT, SZA   "
N1="11.0  62.2 GMT, SZA   "
R2="2    2   Cloud Flags"
N2="1    1   Cloud Flags"
sed -i "s/$R1/$N1/" Data/CTM_GrdCld.dat
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat
./solarj > output
mv output output_clrsky_sza62
# case 1 cirrus/avg cld/SZA=62
R2="1    1   Cloud Flags"
N2="2    2   Cloud Flags"
sed -i "s/$R1/$N1/" Data/CTM_GrdCld.dat
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat
./solarj > output
mv output output_cirrus_sza62
mv fj.dat fj_sza62.dat
mv sj_1.dat sj_1_sza62.dat
mv sj_2.dat sj_2_sza62.dat
mv SWbgt.dat SWbgt_sza62.dat
# case 1 cirrus/avg cld/SZA=84
R1="11.0  62.2 GMT, SZA   "
N1="11.0  84.0 GMT, SZA   "
R2="2    2   Cloud Flags"
N2="1    1   Cloud Flags"
sed -i "s/$R1/$N1/" Data/CTM_GrdCld.dat
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat
./solarj > output
mv output output_clrsky_sza84
# case 1 cirrus/avg cld/SZA=84
R2="1    1   Cloud Flags"
N2="2    2   Cloud Flags"
sed -i "s/$R1/$N1/" Data/CTM_GrdCld.dat
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat
./solarj > output
mv output output_cirrus_sza84
mv fj.dat fj_sza84.dat
mv sj_1.dat sj_1_sza84.dat
mv sj_2.dat sj_2_sza84.dat
mv SWbgt.dat SWbgt_sza84.dat
# sweep all cirrus results under cirrus/
mkdir cirrus
mv *.dat cirrus/
mv output* cirrus/
# 4. start stratus case by cp .bk file over)
cp Data/CTM_GrdCld_stratus.bk Data/CTM_GrdCld.dat
# case 1 clear sky/SZA=0
R1="11.0  12.0 GMT, PHOTAU"
N1="11.0   0.0 GMT, SZA   "
sed -i "s/$R1/$N1/" Data/CTM_GrdCld.dat
./solarj > output
mv output output_clearsky_sza0
# case 1 stratus/avg cld/SZA=0
R2="1    1   Cloud Flags"
N2="2    2   Cloud Flags"
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat 
./solarj > output
mv output output_stratus_sza0
mv fj.dat fj_sza0.dat
mv sj_1.dat sj_1_sza0.dat
mv sj_2.dat sj_2_sza0.dat
mv SWbgt.dat SWbgt_sza0.dat
# case 1 clear sky  /SZA=21
R1="11.0   0.0 GMT, SZA   "
N1="11.0  21.2 GMT, SZA   "
R2="2    2   Cloud Flags"
N2="1    1   Cloud Flags"
sed -i "s/$R1/$N1/" Data/CTM_GrdCld.dat
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat 
./solarj > output
mv output output_clrsky_sza21
# case 1 stratus/avg cld/SZA=21
R2="1    1   Cloud Flags"
N2="2    2   Cloud Flags"
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat
./solarj > output
mv output output_stratus_sza21
mv fj.dat fj_sza21.dat
mv sj_1.dat sj_1_sza21.dat
mv sj_2.dat sj_2_sza21.dat
mv SWbgt.dat SWbgt_sza21.dat
# case 1 stratus/avg cld/SZA=62
R1="11.0  21.2 GMT, SZA   "
N1="11.0  62.2 GMT, SZA   "
R2="2    2   Cloud Flags"
N2="1    1   Cloud Flags"
sed -i "s/$R1/$N1/" Data/CTM_GrdCld.dat
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat
./solarj > output
mv output output_clrsky_sza62
# case 1 stratus/avg cld/SZA=62
R2="1    1   Cloud Flags"
N2="2    2   Cloud Flags"
sed -i "s/$R1/$N1/" Data/CTM_GrdCld.dat
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat
./solarj > output
mv output output_stratus_sza62
mv fj.dat fj_sza62.dat
mv sj_1.dat sj_1_sza62.dat
mv sj_2.dat sj_2_sza62.dat
mv SWbgt.dat SWbgt_sza62.dat
# case 1 stratus/avg cld/SZA=84
R1="11.0  62.2 GMT, SZA   "
N1="11.0  84.0 GMT, SZA   "
R2="2    2   Cloud Flags"
N2="1    1   Cloud Flags"
sed -i "s/$R1/$N1/" Data/CTM_GrdCld.dat
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat
./solarj > output
mv output output_clrsky_sza84
# case 1 stratus/avg cld/SZA=84
R2="1    1   Cloud Flags"
N2="2    2   Cloud Flags"
sed -i "s/$R1/$N1/" Data/CTM_GrdCld.dat
sed -i "s/$R2/$N2/" Data/CTM_GrdCld.dat
./solarj > output
mv output output_stratus_sza84
mv fj.dat fj_sza84.dat
mv sj_1.dat sj_1_sza84.dat
mv sj_2.dat sj_2_sza84.dat
mv SWbgt.dat SWbgt_sza84.dat
mkdir stratus
mv output* stratus/
mv *.dat stratus/

