!     contain only the gas absorption  optical depth and will pass it to Fast-JX 
!
      subroutine rrtmg_sw_inp(nn)

! --------- Modules ---------

      use parkind, only : im => kind_im, rb => kind_rb
      use parrrsw, only : mxlay, nbndsw, ngptsw, naerec, nstr, nmol, mxmol, &
                          jpband, jpb1, jpb2
      use rrsw_con, only : heatfac, oneminus, pi
      use rrsw_wvn, only : wavenum1, wavenum2
      use rrsw_vsn
      use rrsw_fastj_cmn
      use rrtmg_sw_init, only: rrtmg_sw_ini
      use rrtmg_sw_setcoef, only: setcoef_sw
      use rrtmg_sw_taumol, only: taumol_sw


      implicit none
      integer, intent(in) :: nn 
      real(kind=rb), parameter :: cpdair = 1003.5 ! Specific heat capacity of dry air
                                                  ! at constant pressure at 273 K
                                                  ! (J kg-1 K-1)
      integer(kind=im):: laytrop, layswtch, laylow
      integer(kind=im):: jp(mxlay), jt(mxlay), jt1(mxlay)

      real(kind=rb) :: co2mult(mxlay)         ! column amount
      real(kind=rb) :: colmol(mxlay)          ! column amount 
      real(kind=rb) :: &                      !
                         fac00(mxlay), fac01(mxlay), &
                         fac10(mxlay), fac11(mxlay)


      real(kind=rb) :: selffac(mxlay), selffrac(mxlay) 

      integer(kind=im) :: indself(mxlay), indfor(mxlay)

      real(kind=rb) :: forfac(mxlay), forfrac(mxlay)
 
      integer(kind=im) :: I, J

      if(nn .eq. 0) then
         call rrtmg_sw_ini(cpdair) !it needs to be called once only 
      else
!      print*,'nlayers=',nlayers
!      write(6,'(10E10.3)')(pavel(J),J=1,nlayers)
!      write(6,'(10E10.3)')(tavel(J),J=1,nlayers)
!      write(6,'(10E10.3)')(coldry(J),J=1,nlayers)

      call setcoef_sw(nlayers, pavel, tavel, coldry, &
           laytrop, layswtch, laylow, jp, jt, jt1, &
           co2mult, colch4, colco2, colh2o, colmol, &
           colo2, colo3, fac00, fac01, fac10, fac11, &
           selffac, selffrac, indself, forfac, forfrac, indfor)
         
      call taumol_sw(nlayers, &
           colh2o, colco2, colch4, colo2, colo3, colmol, &
           laytrop, jp, jt, jt1, &
           fac00, fac01, fac10, fac11, &
           selffac, selffrac, indself, forfac, forfrac, indfor, &
            taug_rrtmg)

!         DO  J=0 , W_rrtmg,1
!            print*,'ig=', J, 'gas opticaldepth tau'
!            WRITE(6, '(1p 8E10.2)')(TAUG_RRTMG(I,J),I=1,nlayers)
!         END DO

      endif
! Output module version numbers

      end


