
         module rrsw_fastj_cmn
! 1. atmos profiles are passed from fast-j codes to rrtmg codes to
! calcualte optical path of gas absorption
!
! 2. optical depths of rrtmg, taug_rrtmg, are then passed back to fast-J.

! 3. note that rrtmg24/25's 14 gbins (442-778 nm) are
! collapsed into 5 bins (Bins 19-23) according to the similarity of opacity function
! vertictal profiles.

!Bin 18 is for wavelength 412-442 nm; bins 19-23 is from 442-778 nm.
! FL and FFF for bin 24 is for 778-850 nm, used in J-values calculation.
! FW at bin 24 is the first bin from RRTMG Bin-23 for heating calculation

         use parkind ,only : im => kind_im, rb => kind_rb            
         use parrrsw ,only : mxlay, ngptsw, ngs29
    
         implicit none

         public

!OOO is ozone in Fast-JX; == colo3 is ozone in RRTMG-SW
 
         integer(kind=im):: nlayers
         integer(kind=im), parameter:: W_rrtmg= 82 ! = ngs29=82 for using RRTMG  
!         integer(kind=im), parameter:: W_rrtmg= 0  ! = ngs29=82 for using RRTMG  

         real(kind=rb):: pavel(mxlay),tavel(mxlay), pz(0:mxlay), tz(0:mxlay), altz(0:mxlay)  
         real(kind=rb):: colch4(mxlay), colh2o(mxlay), colo3(mxlay), &
                         colo2(mxlay),  colco2(mxlay), coldry(mxlay)
        
         real(kind=rb):: taug_rrtmg(mxlay, 0:ngptsw-1), taur_rrtmg(mxlay,ngptsw),&
              sfluxzen(ngptsw)
         
          end module rrsw_fastj_cmn
